﻿//Library Name: mcs_TSA.OnChange.js
//If the SDK namespace object is not defined, create it.
if (typeof (MCS) == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;
MCS.mcs_TSA_OnChange = {};

//Called from StatusReason
MCS.mcs_TSA_OnChange.ProductionLock = function () {
    var status = Xrm.Page.getAttribute("statuscode").getValue();
    var isProduction = (status == 251920000) ? true : false;
    //Draft or Revision
    var notEditable = (status != 1 && status != 917290007) ? true : false;
    var groupApptOption = (Xrm.Page.getAttribute("cvt_groupappointment") != null) ? Xrm.Page.getAttribute("cvt_groupappointment").getValue() : false;
    var label = (groupApptOption == true) ? "Group Appointment " : "";

    label += (isProduction == true) ? "TSA(Production Lock) ~ Save in Draft to Edit" : "TSA-Draft";

    Xrm.Page.ui.tabs.get("tab_Info").setLabel(label);
    var alwaysDisable = [
        'cvt_relatedprovidersiteid',
        'cvt_servicetype',
        'cvt_servicesubtype',
        'cvt_groupappointment',
        'cvt_provistaclinic',
        'cvt_patvistaclinic',
        'cvt_servicescope',
        'cvt_availabletelehealthmodalities'
    ];

    var disabledFields = [
        'cvt_servicelevels',
        'cvt_relatedpatientsiteid',
        'ownerid',
        //'cvt_providersiteclinicalpoc',
        'cvt_relatedpatientsiteid',
        //'cvt_patientsiteclinicalpoc',
        'cvt_patientfacility'
    ];

    for (fields in alwaysDisable) {
        Xrm.Page.getControl(alwaysDisable[fields]).setDisabled(true);
    }
    for (fields in disabledFields) {
        Xrm.Page.getControl(disabledFields[fields]).setDisabled(notEditable);
    }
    if (!notEditable) {
        MCS.mcs_TSA_OnChange.GroupAppt();
        MCS.mcs_TSA_OnChange.ChangeType();
    }
};

MCS.mcs_TSA_OnChange.GroupAppt = function () {
    var isHomeMobile = Xrm.Page.getAttribute("cvt_type").getValue();
    var patSite = Xrm.Page.getAttribute("cvt_relatedpatientsiteid");
    var patSiteControl = Xrm.Page.getControl("cvt_relatedpatientsiteid");
    var patFac = Xrm.Page.getAttribute("cvt_patientfacility");
    var patFacControl = Xrm.Page.getControl("cvt_patientfacility");
    var status = Xrm.Page.getAttribute("statuscode").getValue();
    var groupApptOptionValue = (Xrm.Page.getAttribute("cvt_groupappointment") != null) ? Xrm.Page.getAttribute("cvt_groupappointment").getValue() : null;
    var label = "";
    if (isHomeMobile) {
        patSite.setRequiredLevel("none");
        patSite.setValue(null);
        patSiteControl.setVisible(false);
        patFac.setRequiredLevel("none");
        patFacControl.setDisabled(true);
        label += "Home/Mobile ";
        if (groupApptOptionValue){
            if (status == 251920000)
                label += "Group Appointment TSA(Production Lock) ~ Save in Draft to Edit";
            else
                label += "Group Appointment TSA-Draft";
        }
        else{
            if (status == 251920000)
                label += 'TSA(Production Lock) ~ Save in Draft to Edit';
            else
                label += 'TSA-Draft';
        }

    }
    else {
        if (groupApptOptionValue == 1) {
            patSite.setRequiredLevel("none");
            patSite.setValue(null);
            patSiteControl.setVisible(false);
            if (!isHomeMobile) {
                patFacControl.setDisabled(false);
                patFac.setRequiredLevel("required");
            }

            if (status == 251920000)
                label = 'Group Appointment TSA(Production Lock) ~ Save in Draft to Edit';
            else
                label = 'Group Appointment TSA-Draft';
        }
        else {
            patSiteControl.setVisible(true);
            patSite.setRequiredLevel("required");
            patFacControl.setDisabled(true);
            patFac.setRequiredLevel("none");
            //Xrm.Page.getControl("mcs_capacity").setDisabled(true);
            if (status == 251920000)
                label = 'TSA(Production Lock) ~ Save in Draft to Edit';
            else
                label = 'TSA-Draft';
        }
        //initialstatus.setValue(4);
        Xrm.Page.ui.tabs.get("tab_Info").setLabel(label);
    }
};

MCS.mcs_TSA_OnChange.StoreForward = function () {
    //Check if this TSA is store forward
    var SFT = Xrm.Page.getAttribute("cvt_availabletelehealthmodalities").getValue() == 917290001;
    Xrm.Page.getControl("cvt_groupappointment").setVisible(!SFT);
};

MCS.mcs_TSA_OnChange.ChangeType = function () {
    if (Xrm.Page.ui.getFormType() == MCS.cvt_Common.FORM_TYPE_CREATE) {
        Xrm.Page.getAttribute("cvt_servicescope").setValue(917290001);
        Xrm.Page.getAttribute("cvt_servicescope").setSubmitMode("always");
    }
    Xrm.Page.getAttribute("cvt_type").setSubmitMode("always");

    if (Xrm.Page.getAttribute("cvt_type").getValue() == true) { //CVT to Home
        Xrm.Page.getControl("cvt_groupappointment").setVisible(true);
        Xrm.Page.getControl("cvt_servicescope").setDisabled(true);

        Xrm.Page.getControl("cvt_relatedpatientsiteid").setVisible(false);
        Xrm.Page.getControl("cvt_patientfacility").setVisible(false);
        Xrm.Page.getAttribute("cvt_relatedpatientsiteid").setRequiredLevel("none");

        Xrm.Page.ui.tabs.get("tab_Pat").setVisible(false);
    }
};

MCS.mcs_TSA_OnChange.setInterIntraFacility = function () {
    var patSiteObj = Xrm.Page.getAttribute("cvt_relatedpatientsiteid");
    var patFacObj = Xrm.Page.getAttribute("cvt_patientfacility");
    var serviceScope = Xrm.Page.getAttribute("cvt_servicescope");
    //Prov site will always be on the form, so go ahead and getValue, Pat Site or Pat Facility will be on form, don't get both
    var provSite = Xrm.Page.getAttribute("cvt_relatedprovidersiteid").getValue();

    if (patSiteObj != null)
        patSiteObj = patSiteObj.getValue();
    if (patFacObj != null)
        patFacObj = patFacObj.getValue();

    //determine if the form is displaying facility or site for patients (based on group or individual)
    var facOrSite = patSiteObj == null ? "facility" : "site";
    //if either pat site/facility or provider site are not populated, do nothing, otherwise, set intrafacility or interfacility for the user
    if (provSite == null || ((facOrSite == "site" && patSiteObj == null) || (facOrSite == "facility" && patFacObj == null)))
        return;
    else {
        //Query Facility for both records and match them
        var provFacilityId = MCS.mcs_TSA_OnChange.QueryFacility(provSite[0].id).Id;
        var patFacilityId = facOrSite == "facility" ? patFacObj[0].id : MCS.mcs_TSA_OnChange.QueryFacility(patSiteObj[0].id).Id;

        //Clean both guids for the compare
        if (MCS.cvt_Common.compareGUIDS(patFacilityId, provFacilityId) == true) { //if facility for patient and provider site are the same, then set service scope to intra-facility
            if (serviceScope.getValue() != 917290001) 
                serviceScope.setValue(917290001);
        }
        else { // if facility for patient and provider site are different, then set service scope to inter-facility
            if (serviceScope.getValue() != 917290000)
                serviceScope.setValue(917290000);                  
        }
        serviceScope.setSubmitMode("always");
    }
};

MCS.mcs_TSA_OnChange.QueryFacility = function (siteID) {
    var facilityId;
    var call = CrmRestKit.Retrieve('mcs_site', siteID, ['mcs_FacilityId'], false);
    call.fail(
        function (error) {
            return;
        }).done(function (site) {
            if (site && site.d) {
                facilityId = site.d.mcs_FacilityId;
            }
        });
    return facilityId; 
};

//Specialty
MCS.mcs_TSA_OnChange.Specialty = function () {
    //See if any sub-types exist
    if (Xrm.Page.getAttribute("cvt_servicetype").getValue() != null) {
        calls = CrmRestKit.ByQuery("mcs_servicesubtype", ['mcs_name'], "cvt_relatedServiceTypeId/Id eq guid'" + Xrm.Page.getAttribute("cvt_servicetype").getValue()[0].id + "'", false);
        calls.fail(function (err) {
            Xrm.Page.getControl("cvt_servicesubtype").setVisible(false);
            Xrm.Page.getAttribute("cvt_servicesubtype").setValue(null);
        }).done(function (data) {
            if (data && data.d && data.d.results != null && data.d.results.length != 0) {
                Xrm.Page.getControl("cvt_servicesubtype").setVisible(true);
                Xrm.Page.getControl("cvt_servicesubtype").setFocus();
            }
            else {
                Xrm.Page.getControl("cvt_servicesubtype").setVisible(false);
                Xrm.Page.getAttribute("cvt_servicesubtype").setValue(null);
            }
            MCS.mcs_TSA_OnLoad.SOS();
        });
    }
    else {
        Xrm.Page.getControl("cvt_servicesubtype").setVisible(false);
        Xrm.Page.getAttribute("cvt_servicesubtype").setValue(null);
    }
};

//Provider Site TCT Team
MCS.mcs_TSA_OnChange.TCTTeamPro = function () {
    //See if any sub-types exist
    if (Xrm.Page.getAttribute("cvt_relatedprovidersiteid").getValue() != null) {
        calls = CrmRestKit.ByQuery("Team", ['Name', 'TeamId'], "cvt_Type/Value eq 917290007 and cvt_TMPSite/Id eq (Guid'" + Xrm.Page.getAttribute("cvt_relatedprovidersiteid").getValue()[0].id + "')", false);
        calls.fail(function (err) {
            //Fail
        }).done(function (data) {
            if (data && data.d && data.d.results != null && data.d.results.length != 0) {
                //Set the TCT Team
                var teamObj = new Array();
                teamObj[0] = new Object();
                teamObj[0].id = data.d.results[0].TeamId;
                teamObj[0].name = data.d.results[0].Name;
                teamObj[0].entityType = 'Team';

                Xrm.Page.getAttribute("cvt_providersitetctteam").setValue(teamObj)
            }
            else
                Xrm.Page.getAttribute("cvt_providersitetctteam").setValue(null);
        });
    }
    else
        Xrm.Page.getAttribute("cvt_providersitetctteam").setValue(null);
};
//Patient Site TCT Team
MCS.mcs_TSA_OnChange.TCTTeamPat = function () {
    //See if any sub-types exist
    if (Xrm.Page.getAttribute("cvt_relatedpatientsiteid").getValue() != null) {
        calls = CrmRestKit.ByQuery("Team", ['Name', 'TeamId'], "cvt_Type/Value eq 917290007 and cvt_TMPSite/Id eq (Guid'" + Xrm.Page.getAttribute("cvt_relatedpatientsiteid").getValue()[0].id + "')", false);
        calls.fail(function (err) {
            //Fail
        }).done(function (data) {
            if (data && data.d && data.d.results != null && data.d.results.length != 0) {
                //Set the TCT Team
                var teamObj = new Array();
                teamObj[0] = new Object();
                teamObj[0].id = data.d.results[0].TeamId;
                teamObj[0].name = data.d.results[0].Name;
                teamObj[0].entityType = 'Team';

                Xrm.Page.getAttribute("cvt_patientsitetctteam").setValue(teamObj)
            }
            else
                Xrm.Page.getAttribute("cvt_patientsitetctteam").setValue(null);
        });
    }
    else
        Xrm.Page.getAttribute("cvt_patientsitetctteam").setValue(null);
};